; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -mtriple=x86_64-linux < %s | FileCheck %s

define range(i32 0, 2) i32 @foo(ptr %this) {
; CHECK-LABEL: foo:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movzbl (%rdi), %eax
; CHECK-NEXT:    retq
entry:
  %call = load volatile i1, ptr %this, align 1
  %spec.select = zext i1 %call to i32
  ret i32 %spec.select
}

define range(i32 0, 2) i32 @bar(ptr %this) {
; CHECK-LABEL: bar:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xorl %edi, %edi
; CHECK-NEXT:    jmp foo@PLT # TAILCALL
entry:
  %ret = musttail call i32 @foo(ptr null)
  ret i32 %ret
}

declare i64 @llvm.llround.f32(float) nounwind readnone
define range(i64 0, 8) i64 @testmsxs(float %x) {
; CHECK-LABEL: testmsxs:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    jmp llroundf@PLT # TAILCALL
entry:
  %ret = tail call i64 @llvm.llround.f32(float %x)
  ret i64 %ret
}

declare i32 @callee()

define range(i32 0, 2) i32 @func_with_range_attr() {
; CHECK-LABEL: func_with_range_attr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    jmp callee@PLT # TAILCALL
entry:
  %ret = musttail call i32 @callee()
  ret i32 %ret
}

define i32 @call_with_range_attr() {
; CHECK-LABEL: call_with_range_attr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    jmp callee@PLT # TAILCALL
entry:
  %ret = musttail call range(i32 0, 2) i32 @callee()
  ret i32 %ret
}
