; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1200 < %s | FileCheck --check-prefix=GCN %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1200 < %s | FileCheck --check-prefix=GCN %s

declare void @llvm.amdgcn.s.buffer.prefetch.data(ptr addrspace(8) %rsrc, i32 %offset, i32 %len)

define amdgpu_ps void @buffer_prefetch_data_imm_offset_sgpr_len(ptr addrspace(8) inreg %rsrc, i32 inreg %len) {
; GCN-LABEL: buffer_prefetch_data_imm_offset_sgpr_len:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_buffer_prefetch_data s[0:3], 0x80, s4, 0
; GCN-NEXT:    s_endpgm
entry:
  tail call void @llvm.amdgcn.s.buffer.prefetch.data(ptr addrspace(8) inreg %rsrc, i32 128, i32 %len)
  ret void
}

define amdgpu_ps void @buffer_prefetch_data_imm_offset_imm_len(ptr addrspace(8) inreg %rsrc) {
; GCN-LABEL: buffer_prefetch_data_imm_offset_imm_len:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_buffer_prefetch_data s[0:3], 0x0, null, 31
; GCN-NEXT:    s_endpgm
entry:
  tail call void @llvm.amdgcn.s.buffer.prefetch.data(ptr addrspace(8) inreg %rsrc, i32 0, i32 31)
  ret void
}

define amdgpu_ps void @buffer_prefetch_data_imm_offset_vgpr_len(ptr addrspace(8) inreg %rsrc, i32 %len) {
; GCN-LABEL: buffer_prefetch_data_imm_offset_vgpr_len:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    v_readfirstlane_b32 s4, v0
; GCN-NEXT:    s_buffer_prefetch_data s[0:3], 0x80, s4, 0
; GCN-NEXT:    s_endpgm
entry:
  tail call void @llvm.amdgcn.s.buffer.prefetch.data(ptr addrspace(8) inreg %rsrc, i32 128, i32 %len)
  ret void
}

define amdgpu_ps void @buffer_prefetch_data_vgpr_rsrc_imm_offset_sgpr_len(ptr addrspace(8) %rsrc, i32 inreg %len) {
; GCN-LABEL: buffer_prefetch_data_vgpr_rsrc_imm_offset_sgpr_len:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    v_readfirstlane_b32 s4, v0
; GCN-NEXT:    v_readfirstlane_b32 s5, v1
; GCN-NEXT:    v_readfirstlane_b32 s6, v2
; GCN-NEXT:    v_readfirstlane_b32 s7, v3
; GCN-NEXT:    s_buffer_prefetch_data s[4:7], 0x80, s0, 0
; GCN-NEXT:    s_endpgm
entry:
  tail call void @llvm.amdgcn.s.buffer.prefetch.data(ptr addrspace(8) inreg %rsrc, i32 128, i32 %len)
  ret void
}
