; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32I
; RUN: llc -mtriple=riscv32 -target-abi ilp32e -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32I-ILP32E
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV64I
; RUN: llc -mtriple=riscv64 -target-abi lp64e -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV64I-LP64E

declare void @callee(ptr)

define void @caller16() {
; RV32I-LABEL: caller16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    .cfi_def_cfa_offset 16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    .cfi_offset ra, -4
; RV32I-NEXT:    mv a0, sp
; RV32I-NEXT:    call callee
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    .cfi_restore ra
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    .cfi_def_cfa_offset 0
; RV32I-NEXT:    ret
;
; RV32I-ILP32E-LABEL: caller16:
; RV32I-ILP32E:       # %bb.0:
; RV32I-ILP32E-NEXT:    addi sp, sp, -16
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 16
; RV32I-ILP32E-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    .cfi_offset ra, -4
; RV32I-ILP32E-NEXT:    .cfi_offset s0, -8
; RV32I-ILP32E-NEXT:    addi s0, sp, 16
; RV32I-ILP32E-NEXT:    .cfi_def_cfa s0, 0
; RV32I-ILP32E-NEXT:    andi sp, sp, -16
; RV32I-ILP32E-NEXT:    mv a0, sp
; RV32I-ILP32E-NEXT:    call callee
; RV32I-ILP32E-NEXT:    addi sp, s0, -16
; RV32I-ILP32E-NEXT:    .cfi_def_cfa sp, 16
; RV32I-ILP32E-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    .cfi_restore ra
; RV32I-ILP32E-NEXT:    .cfi_restore s0
; RV32I-ILP32E-NEXT:    addi sp, sp, 16
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 0
; RV32I-ILP32E-NEXT:    ret
;
; RV64I-LABEL: caller16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    .cfi_def_cfa_offset 16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    .cfi_offset ra, -8
; RV64I-NEXT:    mv a0, sp
; RV64I-NEXT:    call callee
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    .cfi_restore ra
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    .cfi_def_cfa_offset 0
; RV64I-NEXT:    ret
;
; RV64I-LP64E-LABEL: caller16:
; RV64I-LP64E:       # %bb.0:
; RV64I-LP64E-NEXT:    addi sp, sp, -32
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 32
; RV64I-LP64E-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    .cfi_offset ra, -8
; RV64I-LP64E-NEXT:    .cfi_offset s0, -16
; RV64I-LP64E-NEXT:    addi s0, sp, 32
; RV64I-LP64E-NEXT:    .cfi_def_cfa s0, 0
; RV64I-LP64E-NEXT:    andi sp, sp, -16
; RV64I-LP64E-NEXT:    mv a0, sp
; RV64I-LP64E-NEXT:    call callee
; RV64I-LP64E-NEXT:    addi sp, s0, -32
; RV64I-LP64E-NEXT:    .cfi_def_cfa sp, 32
; RV64I-LP64E-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    .cfi_restore ra
; RV64I-LP64E-NEXT:    .cfi_restore s0
; RV64I-LP64E-NEXT:    addi sp, sp, 32
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 0
; RV64I-LP64E-NEXT:    ret
  %1 = alloca i8, align 16
  call void @callee(ptr %1)
  ret void
}

define void @caller_no_realign16() "no-realign-stack" {
; RV32I-LABEL: caller_no_realign16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    .cfi_def_cfa_offset 16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    .cfi_offset ra, -4
; RV32I-NEXT:    mv a0, sp
; RV32I-NEXT:    call callee
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    .cfi_restore ra
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    .cfi_def_cfa_offset 0
; RV32I-NEXT:    ret
;
; RV32I-ILP32E-LABEL: caller_no_realign16:
; RV32I-ILP32E:       # %bb.0:
; RV32I-ILP32E-NEXT:    addi sp, sp, -8
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 8
; RV32I-ILP32E-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    .cfi_offset ra, -4
; RV32I-ILP32E-NEXT:    mv a0, sp
; RV32I-ILP32E-NEXT:    call callee
; RV32I-ILP32E-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    .cfi_restore ra
; RV32I-ILP32E-NEXT:    addi sp, sp, 8
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 0
; RV32I-ILP32E-NEXT:    ret
;
; RV64I-LABEL: caller_no_realign16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    .cfi_def_cfa_offset 16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    .cfi_offset ra, -8
; RV64I-NEXT:    mv a0, sp
; RV64I-NEXT:    call callee
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    .cfi_restore ra
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    .cfi_def_cfa_offset 0
; RV64I-NEXT:    ret
;
; RV64I-LP64E-LABEL: caller_no_realign16:
; RV64I-LP64E:       # %bb.0:
; RV64I-LP64E-NEXT:    addi sp, sp, -16
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 16
; RV64I-LP64E-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    .cfi_offset ra, -8
; RV64I-LP64E-NEXT:    mv a0, sp
; RV64I-LP64E-NEXT:    call callee
; RV64I-LP64E-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    .cfi_restore ra
; RV64I-LP64E-NEXT:    addi sp, sp, 16
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 0
; RV64I-LP64E-NEXT:    ret
  %1 = alloca i8, align 16
  call void @callee(ptr %1)
  ret void
}

define void @caller32() {
; RV32I-LABEL: caller32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    .cfi_def_cfa_offset 32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    .cfi_offset ra, -4
; RV32I-NEXT:    .cfi_offset s0, -8
; RV32I-NEXT:    addi s0, sp, 32
; RV32I-NEXT:    .cfi_def_cfa s0, 0
; RV32I-NEXT:    andi sp, sp, -32
; RV32I-NEXT:    mv a0, sp
; RV32I-NEXT:    call callee
; RV32I-NEXT:    addi sp, s0, -32
; RV32I-NEXT:    .cfi_def_cfa sp, 32
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    .cfi_restore ra
; RV32I-NEXT:    .cfi_restore s0
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    .cfi_def_cfa_offset 0
; RV32I-NEXT:    ret
;
; RV32I-ILP32E-LABEL: caller32:
; RV32I-ILP32E:       # %bb.0:
; RV32I-ILP32E-NEXT:    addi sp, sp, -32
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 32
; RV32I-ILP32E-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    .cfi_offset ra, -4
; RV32I-ILP32E-NEXT:    .cfi_offset s0, -8
; RV32I-ILP32E-NEXT:    addi s0, sp, 32
; RV32I-ILP32E-NEXT:    .cfi_def_cfa s0, 0
; RV32I-ILP32E-NEXT:    andi sp, sp, -32
; RV32I-ILP32E-NEXT:    mv a0, sp
; RV32I-ILP32E-NEXT:    call callee
; RV32I-ILP32E-NEXT:    addi sp, s0, -32
; RV32I-ILP32E-NEXT:    .cfi_def_cfa sp, 32
; RV32I-ILP32E-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    .cfi_restore ra
; RV32I-ILP32E-NEXT:    .cfi_restore s0
; RV32I-ILP32E-NEXT:    addi sp, sp, 32
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 0
; RV32I-ILP32E-NEXT:    ret
;
; RV64I-LABEL: caller32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    .cfi_def_cfa_offset 32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    .cfi_offset ra, -8
; RV64I-NEXT:    .cfi_offset s0, -16
; RV64I-NEXT:    addi s0, sp, 32
; RV64I-NEXT:    .cfi_def_cfa s0, 0
; RV64I-NEXT:    andi sp, sp, -32
; RV64I-NEXT:    mv a0, sp
; RV64I-NEXT:    call callee
; RV64I-NEXT:    addi sp, s0, -32
; RV64I-NEXT:    .cfi_def_cfa sp, 32
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    .cfi_restore ra
; RV64I-NEXT:    .cfi_restore s0
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    .cfi_def_cfa_offset 0
; RV64I-NEXT:    ret
;
; RV64I-LP64E-LABEL: caller32:
; RV64I-LP64E:       # %bb.0:
; RV64I-LP64E-NEXT:    addi sp, sp, -32
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 32
; RV64I-LP64E-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    .cfi_offset ra, -8
; RV64I-LP64E-NEXT:    .cfi_offset s0, -16
; RV64I-LP64E-NEXT:    addi s0, sp, 32
; RV64I-LP64E-NEXT:    .cfi_def_cfa s0, 0
; RV64I-LP64E-NEXT:    andi sp, sp, -32
; RV64I-LP64E-NEXT:    mv a0, sp
; RV64I-LP64E-NEXT:    call callee
; RV64I-LP64E-NEXT:    addi sp, s0, -32
; RV64I-LP64E-NEXT:    .cfi_def_cfa sp, 32
; RV64I-LP64E-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    .cfi_restore ra
; RV64I-LP64E-NEXT:    .cfi_restore s0
; RV64I-LP64E-NEXT:    addi sp, sp, 32
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 0
; RV64I-LP64E-NEXT:    ret
  %1 = alloca i8, align 32
  call void @callee(ptr %1)
  ret void
}

define void @caller_no_realign32() "no-realign-stack" {
; RV32I-LABEL: caller_no_realign32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    .cfi_def_cfa_offset 16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    .cfi_offset ra, -4
; RV32I-NEXT:    mv a0, sp
; RV32I-NEXT:    call callee
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    .cfi_restore ra
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    .cfi_def_cfa_offset 0
; RV32I-NEXT:    ret
;
; RV32I-ILP32E-LABEL: caller_no_realign32:
; RV32I-ILP32E:       # %bb.0:
; RV32I-ILP32E-NEXT:    addi sp, sp, -8
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 8
; RV32I-ILP32E-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    .cfi_offset ra, -4
; RV32I-ILP32E-NEXT:    mv a0, sp
; RV32I-ILP32E-NEXT:    call callee
; RV32I-ILP32E-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    .cfi_restore ra
; RV32I-ILP32E-NEXT:    addi sp, sp, 8
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 0
; RV32I-ILP32E-NEXT:    ret
;
; RV64I-LABEL: caller_no_realign32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    .cfi_def_cfa_offset 16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    .cfi_offset ra, -8
; RV64I-NEXT:    mv a0, sp
; RV64I-NEXT:    call callee
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    .cfi_restore ra
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    .cfi_def_cfa_offset 0
; RV64I-NEXT:    ret
;
; RV64I-LP64E-LABEL: caller_no_realign32:
; RV64I-LP64E:       # %bb.0:
; RV64I-LP64E-NEXT:    addi sp, sp, -16
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 16
; RV64I-LP64E-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    .cfi_offset ra, -8
; RV64I-LP64E-NEXT:    mv a0, sp
; RV64I-LP64E-NEXT:    call callee
; RV64I-LP64E-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    .cfi_restore ra
; RV64I-LP64E-NEXT:    addi sp, sp, 16
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 0
; RV64I-LP64E-NEXT:    ret
  %1 = alloca i8, align 32
  call void @callee(ptr %1)
  ret void
}

define void @caller64() {
; RV32I-LABEL: caller64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -64
; RV32I-NEXT:    .cfi_def_cfa_offset 64
; RV32I-NEXT:    sw ra, 60(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 56(sp) # 4-byte Folded Spill
; RV32I-NEXT:    .cfi_offset ra, -4
; RV32I-NEXT:    .cfi_offset s0, -8
; RV32I-NEXT:    addi s0, sp, 64
; RV32I-NEXT:    .cfi_def_cfa s0, 0
; RV32I-NEXT:    andi sp, sp, -64
; RV32I-NEXT:    mv a0, sp
; RV32I-NEXT:    call callee
; RV32I-NEXT:    addi sp, s0, -64
; RV32I-NEXT:    .cfi_def_cfa sp, 64
; RV32I-NEXT:    lw ra, 60(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 56(sp) # 4-byte Folded Reload
; RV32I-NEXT:    .cfi_restore ra
; RV32I-NEXT:    .cfi_restore s0
; RV32I-NEXT:    addi sp, sp, 64
; RV32I-NEXT:    .cfi_def_cfa_offset 0
; RV32I-NEXT:    ret
;
; RV32I-ILP32E-LABEL: caller64:
; RV32I-ILP32E:       # %bb.0:
; RV32I-ILP32E-NEXT:    addi sp, sp, -64
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 64
; RV32I-ILP32E-NEXT:    sw ra, 60(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    sw s0, 56(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    .cfi_offset ra, -4
; RV32I-ILP32E-NEXT:    .cfi_offset s0, -8
; RV32I-ILP32E-NEXT:    addi s0, sp, 64
; RV32I-ILP32E-NEXT:    .cfi_def_cfa s0, 0
; RV32I-ILP32E-NEXT:    andi sp, sp, -64
; RV32I-ILP32E-NEXT:    mv a0, sp
; RV32I-ILP32E-NEXT:    call callee
; RV32I-ILP32E-NEXT:    addi sp, s0, -64
; RV32I-ILP32E-NEXT:    .cfi_def_cfa sp, 64
; RV32I-ILP32E-NEXT:    lw ra, 60(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    lw s0, 56(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    .cfi_restore ra
; RV32I-ILP32E-NEXT:    .cfi_restore s0
; RV32I-ILP32E-NEXT:    addi sp, sp, 64
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 0
; RV32I-ILP32E-NEXT:    ret
;
; RV64I-LABEL: caller64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -64
; RV64I-NEXT:    .cfi_def_cfa_offset 64
; RV64I-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 48(sp) # 8-byte Folded Spill
; RV64I-NEXT:    .cfi_offset ra, -8
; RV64I-NEXT:    .cfi_offset s0, -16
; RV64I-NEXT:    addi s0, sp, 64
; RV64I-NEXT:    .cfi_def_cfa s0, 0
; RV64I-NEXT:    andi sp, sp, -64
; RV64I-NEXT:    mv a0, sp
; RV64I-NEXT:    call callee
; RV64I-NEXT:    addi sp, s0, -64
; RV64I-NEXT:    .cfi_def_cfa sp, 64
; RV64I-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 48(sp) # 8-byte Folded Reload
; RV64I-NEXT:    .cfi_restore ra
; RV64I-NEXT:    .cfi_restore s0
; RV64I-NEXT:    addi sp, sp, 64
; RV64I-NEXT:    .cfi_def_cfa_offset 0
; RV64I-NEXT:    ret
;
; RV64I-LP64E-LABEL: caller64:
; RV64I-LP64E:       # %bb.0:
; RV64I-LP64E-NEXT:    addi sp, sp, -64
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 64
; RV64I-LP64E-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    sd s0, 48(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    .cfi_offset ra, -8
; RV64I-LP64E-NEXT:    .cfi_offset s0, -16
; RV64I-LP64E-NEXT:    addi s0, sp, 64
; RV64I-LP64E-NEXT:    .cfi_def_cfa s0, 0
; RV64I-LP64E-NEXT:    andi sp, sp, -64
; RV64I-LP64E-NEXT:    mv a0, sp
; RV64I-LP64E-NEXT:    call callee
; RV64I-LP64E-NEXT:    addi sp, s0, -64
; RV64I-LP64E-NEXT:    .cfi_def_cfa sp, 64
; RV64I-LP64E-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    ld s0, 48(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    .cfi_restore ra
; RV64I-LP64E-NEXT:    .cfi_restore s0
; RV64I-LP64E-NEXT:    addi sp, sp, 64
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 0
; RV64I-LP64E-NEXT:    ret
  %1 = alloca i8, align 64
  call void @callee(ptr %1)
  ret void
}

define void @caller_no_realign64() "no-realign-stack" {
; RV32I-LABEL: caller_no_realign64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    .cfi_def_cfa_offset 16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    .cfi_offset ra, -4
; RV32I-NEXT:    mv a0, sp
; RV32I-NEXT:    call callee
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    .cfi_restore ra
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    .cfi_def_cfa_offset 0
; RV32I-NEXT:    ret
;
; RV32I-ILP32E-LABEL: caller_no_realign64:
; RV32I-ILP32E:       # %bb.0:
; RV32I-ILP32E-NEXT:    addi sp, sp, -8
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 8
; RV32I-ILP32E-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    .cfi_offset ra, -4
; RV32I-ILP32E-NEXT:    mv a0, sp
; RV32I-ILP32E-NEXT:    call callee
; RV32I-ILP32E-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    .cfi_restore ra
; RV32I-ILP32E-NEXT:    addi sp, sp, 8
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 0
; RV32I-ILP32E-NEXT:    ret
;
; RV64I-LABEL: caller_no_realign64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    .cfi_def_cfa_offset 16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    .cfi_offset ra, -8
; RV64I-NEXT:    mv a0, sp
; RV64I-NEXT:    call callee
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    .cfi_restore ra
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    .cfi_def_cfa_offset 0
; RV64I-NEXT:    ret
;
; RV64I-LP64E-LABEL: caller_no_realign64:
; RV64I-LP64E:       # %bb.0:
; RV64I-LP64E-NEXT:    addi sp, sp, -16
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 16
; RV64I-LP64E-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    .cfi_offset ra, -8
; RV64I-LP64E-NEXT:    mv a0, sp
; RV64I-LP64E-NEXT:    call callee
; RV64I-LP64E-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    .cfi_restore ra
; RV64I-LP64E-NEXT:    addi sp, sp, 16
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 0
; RV64I-LP64E-NEXT:    ret
  %1 = alloca i8, align 64
  call void @callee(ptr %1)
  ret void
}

define void @caller128() {
; RV32I-LABEL: caller128:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -128
; RV32I-NEXT:    .cfi_def_cfa_offset 128
; RV32I-NEXT:    sw ra, 124(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 120(sp) # 4-byte Folded Spill
; RV32I-NEXT:    .cfi_offset ra, -4
; RV32I-NEXT:    .cfi_offset s0, -8
; RV32I-NEXT:    addi s0, sp, 128
; RV32I-NEXT:    .cfi_def_cfa s0, 0
; RV32I-NEXT:    andi sp, sp, -128
; RV32I-NEXT:    mv a0, sp
; RV32I-NEXT:    call callee
; RV32I-NEXT:    addi sp, s0, -128
; RV32I-NEXT:    .cfi_def_cfa sp, 128
; RV32I-NEXT:    lw ra, 124(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 120(sp) # 4-byte Folded Reload
; RV32I-NEXT:    .cfi_restore ra
; RV32I-NEXT:    .cfi_restore s0
; RV32I-NEXT:    addi sp, sp, 128
; RV32I-NEXT:    .cfi_def_cfa_offset 0
; RV32I-NEXT:    ret
;
; RV32I-ILP32E-LABEL: caller128:
; RV32I-ILP32E:       # %bb.0:
; RV32I-ILP32E-NEXT:    addi sp, sp, -128
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 128
; RV32I-ILP32E-NEXT:    sw ra, 124(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    sw s0, 120(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    .cfi_offset ra, -4
; RV32I-ILP32E-NEXT:    .cfi_offset s0, -8
; RV32I-ILP32E-NEXT:    addi s0, sp, 128
; RV32I-ILP32E-NEXT:    .cfi_def_cfa s0, 0
; RV32I-ILP32E-NEXT:    andi sp, sp, -128
; RV32I-ILP32E-NEXT:    mv a0, sp
; RV32I-ILP32E-NEXT:    call callee
; RV32I-ILP32E-NEXT:    addi sp, s0, -128
; RV32I-ILP32E-NEXT:    .cfi_def_cfa sp, 128
; RV32I-ILP32E-NEXT:    lw ra, 124(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    lw s0, 120(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    .cfi_restore ra
; RV32I-ILP32E-NEXT:    .cfi_restore s0
; RV32I-ILP32E-NEXT:    addi sp, sp, 128
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 0
; RV32I-ILP32E-NEXT:    ret
;
; RV64I-LABEL: caller128:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -128
; RV64I-NEXT:    .cfi_def_cfa_offset 128
; RV64I-NEXT:    sd ra, 120(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 112(sp) # 8-byte Folded Spill
; RV64I-NEXT:    .cfi_offset ra, -8
; RV64I-NEXT:    .cfi_offset s0, -16
; RV64I-NEXT:    addi s0, sp, 128
; RV64I-NEXT:    .cfi_def_cfa s0, 0
; RV64I-NEXT:    andi sp, sp, -128
; RV64I-NEXT:    mv a0, sp
; RV64I-NEXT:    call callee
; RV64I-NEXT:    addi sp, s0, -128
; RV64I-NEXT:    .cfi_def_cfa sp, 128
; RV64I-NEXT:    ld ra, 120(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 112(sp) # 8-byte Folded Reload
; RV64I-NEXT:    .cfi_restore ra
; RV64I-NEXT:    .cfi_restore s0
; RV64I-NEXT:    addi sp, sp, 128
; RV64I-NEXT:    .cfi_def_cfa_offset 0
; RV64I-NEXT:    ret
;
; RV64I-LP64E-LABEL: caller128:
; RV64I-LP64E:       # %bb.0:
; RV64I-LP64E-NEXT:    addi sp, sp, -128
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 128
; RV64I-LP64E-NEXT:    sd ra, 120(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    sd s0, 112(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    .cfi_offset ra, -8
; RV64I-LP64E-NEXT:    .cfi_offset s0, -16
; RV64I-LP64E-NEXT:    addi s0, sp, 128
; RV64I-LP64E-NEXT:    .cfi_def_cfa s0, 0
; RV64I-LP64E-NEXT:    andi sp, sp, -128
; RV64I-LP64E-NEXT:    mv a0, sp
; RV64I-LP64E-NEXT:    call callee
; RV64I-LP64E-NEXT:    addi sp, s0, -128
; RV64I-LP64E-NEXT:    .cfi_def_cfa sp, 128
; RV64I-LP64E-NEXT:    ld ra, 120(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    ld s0, 112(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    .cfi_restore ra
; RV64I-LP64E-NEXT:    .cfi_restore s0
; RV64I-LP64E-NEXT:    addi sp, sp, 128
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 0
; RV64I-LP64E-NEXT:    ret
  %1 = alloca i8, align 128
  call void @callee(ptr %1)
  ret void
}

define void @caller_no_realign128() "no-realign-stack" {
; RV32I-LABEL: caller_no_realign128:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    .cfi_def_cfa_offset 16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    .cfi_offset ra, -4
; RV32I-NEXT:    mv a0, sp
; RV32I-NEXT:    call callee
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    .cfi_restore ra
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    .cfi_def_cfa_offset 0
; RV32I-NEXT:    ret
;
; RV32I-ILP32E-LABEL: caller_no_realign128:
; RV32I-ILP32E:       # %bb.0:
; RV32I-ILP32E-NEXT:    addi sp, sp, -8
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 8
; RV32I-ILP32E-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    .cfi_offset ra, -4
; RV32I-ILP32E-NEXT:    mv a0, sp
; RV32I-ILP32E-NEXT:    call callee
; RV32I-ILP32E-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    .cfi_restore ra
; RV32I-ILP32E-NEXT:    addi sp, sp, 8
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 0
; RV32I-ILP32E-NEXT:    ret
;
; RV64I-LABEL: caller_no_realign128:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    .cfi_def_cfa_offset 16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    .cfi_offset ra, -8
; RV64I-NEXT:    mv a0, sp
; RV64I-NEXT:    call callee
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    .cfi_restore ra
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    .cfi_def_cfa_offset 0
; RV64I-NEXT:    ret
;
; RV64I-LP64E-LABEL: caller_no_realign128:
; RV64I-LP64E:       # %bb.0:
; RV64I-LP64E-NEXT:    addi sp, sp, -16
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 16
; RV64I-LP64E-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    .cfi_offset ra, -8
; RV64I-LP64E-NEXT:    mv a0, sp
; RV64I-LP64E-NEXT:    call callee
; RV64I-LP64E-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    .cfi_restore ra
; RV64I-LP64E-NEXT:    addi sp, sp, 16
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 0
; RV64I-LP64E-NEXT:    ret
  %1 = alloca i8, align 128
  call void @callee(ptr %1)
  ret void
}

define void @caller256() {
; RV32I-LABEL: caller256:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -256
; RV32I-NEXT:    .cfi_def_cfa_offset 256
; RV32I-NEXT:    sw ra, 252(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 248(sp) # 4-byte Folded Spill
; RV32I-NEXT:    .cfi_offset ra, -4
; RV32I-NEXT:    .cfi_offset s0, -8
; RV32I-NEXT:    addi s0, sp, 256
; RV32I-NEXT:    .cfi_def_cfa s0, 0
; RV32I-NEXT:    andi sp, sp, -256
; RV32I-NEXT:    mv a0, sp
; RV32I-NEXT:    call callee
; RV32I-NEXT:    addi sp, s0, -256
; RV32I-NEXT:    .cfi_def_cfa sp, 256
; RV32I-NEXT:    lw ra, 252(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 248(sp) # 4-byte Folded Reload
; RV32I-NEXT:    .cfi_restore ra
; RV32I-NEXT:    .cfi_restore s0
; RV32I-NEXT:    addi sp, sp, 256
; RV32I-NEXT:    .cfi_def_cfa_offset 0
; RV32I-NEXT:    ret
;
; RV32I-ILP32E-LABEL: caller256:
; RV32I-ILP32E:       # %bb.0:
; RV32I-ILP32E-NEXT:    addi sp, sp, -256
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 256
; RV32I-ILP32E-NEXT:    sw ra, 252(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    sw s0, 248(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    .cfi_offset ra, -4
; RV32I-ILP32E-NEXT:    .cfi_offset s0, -8
; RV32I-ILP32E-NEXT:    addi s0, sp, 256
; RV32I-ILP32E-NEXT:    .cfi_def_cfa s0, 0
; RV32I-ILP32E-NEXT:    andi sp, sp, -256
; RV32I-ILP32E-NEXT:    mv a0, sp
; RV32I-ILP32E-NEXT:    call callee
; RV32I-ILP32E-NEXT:    addi sp, s0, -256
; RV32I-ILP32E-NEXT:    .cfi_def_cfa sp, 256
; RV32I-ILP32E-NEXT:    lw ra, 252(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    lw s0, 248(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    .cfi_restore ra
; RV32I-ILP32E-NEXT:    .cfi_restore s0
; RV32I-ILP32E-NEXT:    addi sp, sp, 256
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 0
; RV32I-ILP32E-NEXT:    ret
;
; RV64I-LABEL: caller256:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -256
; RV64I-NEXT:    .cfi_def_cfa_offset 256
; RV64I-NEXT:    sd ra, 248(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 240(sp) # 8-byte Folded Spill
; RV64I-NEXT:    .cfi_offset ra, -8
; RV64I-NEXT:    .cfi_offset s0, -16
; RV64I-NEXT:    addi s0, sp, 256
; RV64I-NEXT:    .cfi_def_cfa s0, 0
; RV64I-NEXT:    andi sp, sp, -256
; RV64I-NEXT:    mv a0, sp
; RV64I-NEXT:    call callee
; RV64I-NEXT:    addi sp, s0, -256
; RV64I-NEXT:    .cfi_def_cfa sp, 256
; RV64I-NEXT:    ld ra, 248(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 240(sp) # 8-byte Folded Reload
; RV64I-NEXT:    .cfi_restore ra
; RV64I-NEXT:    .cfi_restore s0
; RV64I-NEXT:    addi sp, sp, 256
; RV64I-NEXT:    .cfi_def_cfa_offset 0
; RV64I-NEXT:    ret
;
; RV64I-LP64E-LABEL: caller256:
; RV64I-LP64E:       # %bb.0:
; RV64I-LP64E-NEXT:    addi sp, sp, -256
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 256
; RV64I-LP64E-NEXT:    sd ra, 248(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    sd s0, 240(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    .cfi_offset ra, -8
; RV64I-LP64E-NEXT:    .cfi_offset s0, -16
; RV64I-LP64E-NEXT:    addi s0, sp, 256
; RV64I-LP64E-NEXT:    .cfi_def_cfa s0, 0
; RV64I-LP64E-NEXT:    andi sp, sp, -256
; RV64I-LP64E-NEXT:    mv a0, sp
; RV64I-LP64E-NEXT:    call callee
; RV64I-LP64E-NEXT:    addi sp, s0, -256
; RV64I-LP64E-NEXT:    .cfi_def_cfa sp, 256
; RV64I-LP64E-NEXT:    ld ra, 248(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    ld s0, 240(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    .cfi_restore ra
; RV64I-LP64E-NEXT:    .cfi_restore s0
; RV64I-LP64E-NEXT:    addi sp, sp, 256
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 0
; RV64I-LP64E-NEXT:    ret
  %1 = alloca i8, align 256
  call void @callee(ptr %1)
  ret void
}

define void @caller_no_realign256() "no-realign-stack" {
; RV32I-LABEL: caller_no_realign256:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    .cfi_def_cfa_offset 16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    .cfi_offset ra, -4
; RV32I-NEXT:    mv a0, sp
; RV32I-NEXT:    call callee
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    .cfi_restore ra
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    .cfi_def_cfa_offset 0
; RV32I-NEXT:    ret
;
; RV32I-ILP32E-LABEL: caller_no_realign256:
; RV32I-ILP32E:       # %bb.0:
; RV32I-ILP32E-NEXT:    addi sp, sp, -8
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 8
; RV32I-ILP32E-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    .cfi_offset ra, -4
; RV32I-ILP32E-NEXT:    mv a0, sp
; RV32I-ILP32E-NEXT:    call callee
; RV32I-ILP32E-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    .cfi_restore ra
; RV32I-ILP32E-NEXT:    addi sp, sp, 8
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 0
; RV32I-ILP32E-NEXT:    ret
;
; RV64I-LABEL: caller_no_realign256:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    .cfi_def_cfa_offset 16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    .cfi_offset ra, -8
; RV64I-NEXT:    mv a0, sp
; RV64I-NEXT:    call callee
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    .cfi_restore ra
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    .cfi_def_cfa_offset 0
; RV64I-NEXT:    ret
;
; RV64I-LP64E-LABEL: caller_no_realign256:
; RV64I-LP64E:       # %bb.0:
; RV64I-LP64E-NEXT:    addi sp, sp, -16
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 16
; RV64I-LP64E-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    .cfi_offset ra, -8
; RV64I-LP64E-NEXT:    mv a0, sp
; RV64I-LP64E-NEXT:    call callee
; RV64I-LP64E-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    .cfi_restore ra
; RV64I-LP64E-NEXT:    addi sp, sp, 16
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 0
; RV64I-LP64E-NEXT:    ret
  %1 = alloca i8, align 256
  call void @callee(ptr %1)
  ret void
}

define void @caller512() {
; RV32I-LABEL: caller512:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -1024
; RV32I-NEXT:    .cfi_def_cfa_offset 1024
; RV32I-NEXT:    sw ra, 1020(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 1016(sp) # 4-byte Folded Spill
; RV32I-NEXT:    .cfi_offset ra, -4
; RV32I-NEXT:    .cfi_offset s0, -8
; RV32I-NEXT:    addi s0, sp, 1024
; RV32I-NEXT:    .cfi_def_cfa s0, 0
; RV32I-NEXT:    andi sp, sp, -512
; RV32I-NEXT:    addi a0, sp, 512
; RV32I-NEXT:    call callee
; RV32I-NEXT:    addi sp, s0, -1024
; RV32I-NEXT:    .cfi_def_cfa sp, 1024
; RV32I-NEXT:    lw ra, 1020(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 1016(sp) # 4-byte Folded Reload
; RV32I-NEXT:    .cfi_restore ra
; RV32I-NEXT:    .cfi_restore s0
; RV32I-NEXT:    addi sp, sp, 1024
; RV32I-NEXT:    .cfi_def_cfa_offset 0
; RV32I-NEXT:    ret
;
; RV32I-ILP32E-LABEL: caller512:
; RV32I-ILP32E:       # %bb.0:
; RV32I-ILP32E-NEXT:    addi sp, sp, -1024
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 1024
; RV32I-ILP32E-NEXT:    sw ra, 1020(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    sw s0, 1016(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    .cfi_offset ra, -4
; RV32I-ILP32E-NEXT:    .cfi_offset s0, -8
; RV32I-ILP32E-NEXT:    addi s0, sp, 1024
; RV32I-ILP32E-NEXT:    .cfi_def_cfa s0, 0
; RV32I-ILP32E-NEXT:    andi sp, sp, -512
; RV32I-ILP32E-NEXT:    addi a0, sp, 512
; RV32I-ILP32E-NEXT:    call callee
; RV32I-ILP32E-NEXT:    addi sp, s0, -1024
; RV32I-ILP32E-NEXT:    .cfi_def_cfa sp, 1024
; RV32I-ILP32E-NEXT:    lw ra, 1020(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    lw s0, 1016(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    .cfi_restore ra
; RV32I-ILP32E-NEXT:    .cfi_restore s0
; RV32I-ILP32E-NEXT:    addi sp, sp, 1024
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 0
; RV32I-ILP32E-NEXT:    ret
;
; RV64I-LABEL: caller512:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -1024
; RV64I-NEXT:    .cfi_def_cfa_offset 1024
; RV64I-NEXT:    sd ra, 1016(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 1008(sp) # 8-byte Folded Spill
; RV64I-NEXT:    .cfi_offset ra, -8
; RV64I-NEXT:    .cfi_offset s0, -16
; RV64I-NEXT:    addi s0, sp, 1024
; RV64I-NEXT:    .cfi_def_cfa s0, 0
; RV64I-NEXT:    andi sp, sp, -512
; RV64I-NEXT:    addi a0, sp, 512
; RV64I-NEXT:    call callee
; RV64I-NEXT:    addi sp, s0, -1024
; RV64I-NEXT:    .cfi_def_cfa sp, 1024
; RV64I-NEXT:    ld ra, 1016(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 1008(sp) # 8-byte Folded Reload
; RV64I-NEXT:    .cfi_restore ra
; RV64I-NEXT:    .cfi_restore s0
; RV64I-NEXT:    addi sp, sp, 1024
; RV64I-NEXT:    .cfi_def_cfa_offset 0
; RV64I-NEXT:    ret
;
; RV64I-LP64E-LABEL: caller512:
; RV64I-LP64E:       # %bb.0:
; RV64I-LP64E-NEXT:    addi sp, sp, -1024
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 1024
; RV64I-LP64E-NEXT:    sd ra, 1016(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    sd s0, 1008(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    .cfi_offset ra, -8
; RV64I-LP64E-NEXT:    .cfi_offset s0, -16
; RV64I-LP64E-NEXT:    addi s0, sp, 1024
; RV64I-LP64E-NEXT:    .cfi_def_cfa s0, 0
; RV64I-LP64E-NEXT:    andi sp, sp, -512
; RV64I-LP64E-NEXT:    addi a0, sp, 512
; RV64I-LP64E-NEXT:    call callee
; RV64I-LP64E-NEXT:    addi sp, s0, -1024
; RV64I-LP64E-NEXT:    .cfi_def_cfa sp, 1024
; RV64I-LP64E-NEXT:    ld ra, 1016(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    ld s0, 1008(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    .cfi_restore ra
; RV64I-LP64E-NEXT:    .cfi_restore s0
; RV64I-LP64E-NEXT:    addi sp, sp, 1024
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 0
; RV64I-LP64E-NEXT:    ret
  %1 = alloca i8, align 512
  call void @callee(ptr %1)
  ret void
}

define void @caller_no_realign512() "no-realign-stack" {
; RV32I-LABEL: caller_no_realign512:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    .cfi_def_cfa_offset 16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    .cfi_offset ra, -4
; RV32I-NEXT:    mv a0, sp
; RV32I-NEXT:    call callee
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    .cfi_restore ra
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    .cfi_def_cfa_offset 0
; RV32I-NEXT:    ret
;
; RV32I-ILP32E-LABEL: caller_no_realign512:
; RV32I-ILP32E:       # %bb.0:
; RV32I-ILP32E-NEXT:    addi sp, sp, -8
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 8
; RV32I-ILP32E-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    .cfi_offset ra, -4
; RV32I-ILP32E-NEXT:    mv a0, sp
; RV32I-ILP32E-NEXT:    call callee
; RV32I-ILP32E-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    .cfi_restore ra
; RV32I-ILP32E-NEXT:    addi sp, sp, 8
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 0
; RV32I-ILP32E-NEXT:    ret
;
; RV64I-LABEL: caller_no_realign512:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    .cfi_def_cfa_offset 16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    .cfi_offset ra, -8
; RV64I-NEXT:    mv a0, sp
; RV64I-NEXT:    call callee
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    .cfi_restore ra
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    .cfi_def_cfa_offset 0
; RV64I-NEXT:    ret
;
; RV64I-LP64E-LABEL: caller_no_realign512:
; RV64I-LP64E:       # %bb.0:
; RV64I-LP64E-NEXT:    addi sp, sp, -16
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 16
; RV64I-LP64E-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    .cfi_offset ra, -8
; RV64I-LP64E-NEXT:    mv a0, sp
; RV64I-LP64E-NEXT:    call callee
; RV64I-LP64E-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    .cfi_restore ra
; RV64I-LP64E-NEXT:    addi sp, sp, 16
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 0
; RV64I-LP64E-NEXT:    ret
  %1 = alloca i8, align 512
  call void @callee(ptr %1)
  ret void
}

define void @caller1024() {
; RV32I-LABEL: caller1024:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -2032
; RV32I-NEXT:    .cfi_def_cfa_offset 2032
; RV32I-NEXT:    sw ra, 2028(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 2024(sp) # 4-byte Folded Spill
; RV32I-NEXT:    .cfi_offset ra, -4
; RV32I-NEXT:    .cfi_offset s0, -8
; RV32I-NEXT:    addi s0, sp, 2032
; RV32I-NEXT:    .cfi_def_cfa s0, 0
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    andi sp, sp, -1024
; RV32I-NEXT:    addi a0, sp, 1024
; RV32I-NEXT:    call callee
; RV32I-NEXT:    addi sp, s0, -2032
; RV32I-NEXT:    .cfi_def_cfa sp, 2032
; RV32I-NEXT:    lw ra, 2028(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 2024(sp) # 4-byte Folded Reload
; RV32I-NEXT:    .cfi_restore ra
; RV32I-NEXT:    .cfi_restore s0
; RV32I-NEXT:    addi sp, sp, 2032
; RV32I-NEXT:    .cfi_def_cfa_offset 0
; RV32I-NEXT:    ret
;
; RV32I-ILP32E-LABEL: caller1024:
; RV32I-ILP32E:       # %bb.0:
; RV32I-ILP32E-NEXT:    addi sp, sp, -2044
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 2044
; RV32I-ILP32E-NEXT:    sw ra, 2040(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    sw s0, 2036(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    .cfi_offset ra, -4
; RV32I-ILP32E-NEXT:    .cfi_offset s0, -8
; RV32I-ILP32E-NEXT:    addi s0, sp, 2044
; RV32I-ILP32E-NEXT:    .cfi_def_cfa s0, 0
; RV32I-ILP32E-NEXT:    addi sp, sp, -4
; RV32I-ILP32E-NEXT:    andi sp, sp, -1024
; RV32I-ILP32E-NEXT:    addi a0, sp, 1024
; RV32I-ILP32E-NEXT:    call callee
; RV32I-ILP32E-NEXT:    addi sp, s0, -2044
; RV32I-ILP32E-NEXT:    .cfi_def_cfa sp, 2044
; RV32I-ILP32E-NEXT:    lw ra, 2040(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    lw s0, 2036(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    .cfi_restore ra
; RV32I-ILP32E-NEXT:    .cfi_restore s0
; RV32I-ILP32E-NEXT:    addi sp, sp, 2044
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 0
; RV32I-ILP32E-NEXT:    ret
;
; RV64I-LABEL: caller1024:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -2032
; RV64I-NEXT:    .cfi_def_cfa_offset 2032
; RV64I-NEXT:    sd ra, 2024(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 2016(sp) # 8-byte Folded Spill
; RV64I-NEXT:    .cfi_offset ra, -8
; RV64I-NEXT:    .cfi_offset s0, -16
; RV64I-NEXT:    addi s0, sp, 2032
; RV64I-NEXT:    .cfi_def_cfa s0, 0
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    andi sp, sp, -1024
; RV64I-NEXT:    addi a0, sp, 1024
; RV64I-NEXT:    call callee
; RV64I-NEXT:    addi sp, s0, -2032
; RV64I-NEXT:    .cfi_def_cfa sp, 2032
; RV64I-NEXT:    ld ra, 2024(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 2016(sp) # 8-byte Folded Reload
; RV64I-NEXT:    .cfi_restore ra
; RV64I-NEXT:    .cfi_restore s0
; RV64I-NEXT:    addi sp, sp, 2032
; RV64I-NEXT:    .cfi_def_cfa_offset 0
; RV64I-NEXT:    ret
;
; RV64I-LP64E-LABEL: caller1024:
; RV64I-LP64E:       # %bb.0:
; RV64I-LP64E-NEXT:    addi sp, sp, -2040
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 2040
; RV64I-LP64E-NEXT:    sd ra, 2032(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    sd s0, 2024(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    .cfi_offset ra, -8
; RV64I-LP64E-NEXT:    .cfi_offset s0, -16
; RV64I-LP64E-NEXT:    addi s0, sp, 2040
; RV64I-LP64E-NEXT:    .cfi_def_cfa s0, 0
; RV64I-LP64E-NEXT:    addi sp, sp, -8
; RV64I-LP64E-NEXT:    andi sp, sp, -1024
; RV64I-LP64E-NEXT:    addi a0, sp, 1024
; RV64I-LP64E-NEXT:    call callee
; RV64I-LP64E-NEXT:    addi sp, s0, -2040
; RV64I-LP64E-NEXT:    .cfi_def_cfa sp, 2040
; RV64I-LP64E-NEXT:    ld ra, 2032(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    ld s0, 2024(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    .cfi_restore ra
; RV64I-LP64E-NEXT:    .cfi_restore s0
; RV64I-LP64E-NEXT:    addi sp, sp, 2040
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 0
; RV64I-LP64E-NEXT:    ret
  %1 = alloca i8, align 1024
  call void @callee(ptr %1)
  ret void
}

define void @caller_no_realign1024() "no-realign-stack" {
; RV32I-LABEL: caller_no_realign1024:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    .cfi_def_cfa_offset 16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    .cfi_offset ra, -4
; RV32I-NEXT:    mv a0, sp
; RV32I-NEXT:    call callee
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    .cfi_restore ra
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    .cfi_def_cfa_offset 0
; RV32I-NEXT:    ret
;
; RV32I-ILP32E-LABEL: caller_no_realign1024:
; RV32I-ILP32E:       # %bb.0:
; RV32I-ILP32E-NEXT:    addi sp, sp, -8
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 8
; RV32I-ILP32E-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    .cfi_offset ra, -4
; RV32I-ILP32E-NEXT:    mv a0, sp
; RV32I-ILP32E-NEXT:    call callee
; RV32I-ILP32E-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    .cfi_restore ra
; RV32I-ILP32E-NEXT:    addi sp, sp, 8
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 0
; RV32I-ILP32E-NEXT:    ret
;
; RV64I-LABEL: caller_no_realign1024:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    .cfi_def_cfa_offset 16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    .cfi_offset ra, -8
; RV64I-NEXT:    mv a0, sp
; RV64I-NEXT:    call callee
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    .cfi_restore ra
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    .cfi_def_cfa_offset 0
; RV64I-NEXT:    ret
;
; RV64I-LP64E-LABEL: caller_no_realign1024:
; RV64I-LP64E:       # %bb.0:
; RV64I-LP64E-NEXT:    addi sp, sp, -16
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 16
; RV64I-LP64E-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    .cfi_offset ra, -8
; RV64I-LP64E-NEXT:    mv a0, sp
; RV64I-LP64E-NEXT:    call callee
; RV64I-LP64E-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    .cfi_restore ra
; RV64I-LP64E-NEXT:    addi sp, sp, 16
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 0
; RV64I-LP64E-NEXT:    ret
  %1 = alloca i8, align 1024
  call void @callee(ptr %1)
  ret void
}

define void @caller2048() {
; RV32I-LABEL: caller2048:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -2032
; RV32I-NEXT:    .cfi_def_cfa_offset 2032
; RV32I-NEXT:    sw ra, 2028(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 2024(sp) # 4-byte Folded Spill
; RV32I-NEXT:    .cfi_offset ra, -4
; RV32I-NEXT:    .cfi_offset s0, -8
; RV32I-NEXT:    addi s0, sp, 2032
; RV32I-NEXT:    .cfi_def_cfa s0, 0
; RV32I-NEXT:    addi sp, sp, -2048
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    andi sp, sp, -2048
; RV32I-NEXT:    addi a0, sp, 2047
; RV32I-NEXT:    addi a0, a0, 1
; RV32I-NEXT:    call callee
; RV32I-NEXT:    addi sp, s0, -2032
; RV32I-NEXT:    .cfi_def_cfa sp, 2032
; RV32I-NEXT:    lw ra, 2028(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 2024(sp) # 4-byte Folded Reload
; RV32I-NEXT:    .cfi_restore ra
; RV32I-NEXT:    .cfi_restore s0
; RV32I-NEXT:    addi sp, sp, 2032
; RV32I-NEXT:    .cfi_def_cfa_offset 0
; RV32I-NEXT:    ret
;
; RV32I-ILP32E-LABEL: caller2048:
; RV32I-ILP32E:       # %bb.0:
; RV32I-ILP32E-NEXT:    addi sp, sp, -2044
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 2044
; RV32I-ILP32E-NEXT:    sw ra, 2040(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    sw s0, 2036(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    .cfi_offset ra, -4
; RV32I-ILP32E-NEXT:    .cfi_offset s0, -8
; RV32I-ILP32E-NEXT:    addi s0, sp, 2044
; RV32I-ILP32E-NEXT:    .cfi_def_cfa s0, 0
; RV32I-ILP32E-NEXT:    addi sp, sp, -2048
; RV32I-ILP32E-NEXT:    addi sp, sp, -4
; RV32I-ILP32E-NEXT:    andi sp, sp, -2048
; RV32I-ILP32E-NEXT:    addi a0, sp, 2047
; RV32I-ILP32E-NEXT:    addi a0, a0, 1
; RV32I-ILP32E-NEXT:    call callee
; RV32I-ILP32E-NEXT:    addi sp, s0, -2044
; RV32I-ILP32E-NEXT:    .cfi_def_cfa sp, 2044
; RV32I-ILP32E-NEXT:    lw ra, 2040(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    lw s0, 2036(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    .cfi_restore ra
; RV32I-ILP32E-NEXT:    .cfi_restore s0
; RV32I-ILP32E-NEXT:    addi sp, sp, 2044
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 0
; RV32I-ILP32E-NEXT:    ret
;
; RV64I-LABEL: caller2048:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -2032
; RV64I-NEXT:    .cfi_def_cfa_offset 2032
; RV64I-NEXT:    sd ra, 2024(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 2016(sp) # 8-byte Folded Spill
; RV64I-NEXT:    .cfi_offset ra, -8
; RV64I-NEXT:    .cfi_offset s0, -16
; RV64I-NEXT:    addi s0, sp, 2032
; RV64I-NEXT:    .cfi_def_cfa s0, 0
; RV64I-NEXT:    addi sp, sp, -2048
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    andi sp, sp, -2048
; RV64I-NEXT:    addi a0, sp, 2047
; RV64I-NEXT:    addi a0, a0, 1
; RV64I-NEXT:    call callee
; RV64I-NEXT:    addi sp, s0, -2032
; RV64I-NEXT:    .cfi_def_cfa sp, 2032
; RV64I-NEXT:    ld ra, 2024(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 2016(sp) # 8-byte Folded Reload
; RV64I-NEXT:    .cfi_restore ra
; RV64I-NEXT:    .cfi_restore s0
; RV64I-NEXT:    addi sp, sp, 2032
; RV64I-NEXT:    .cfi_def_cfa_offset 0
; RV64I-NEXT:    ret
;
; RV64I-LP64E-LABEL: caller2048:
; RV64I-LP64E:       # %bb.0:
; RV64I-LP64E-NEXT:    addi sp, sp, -2040
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 2040
; RV64I-LP64E-NEXT:    sd ra, 2032(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    sd s0, 2024(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    .cfi_offset ra, -8
; RV64I-LP64E-NEXT:    .cfi_offset s0, -16
; RV64I-LP64E-NEXT:    addi s0, sp, 2040
; RV64I-LP64E-NEXT:    .cfi_def_cfa s0, 0
; RV64I-LP64E-NEXT:    addi sp, sp, -2048
; RV64I-LP64E-NEXT:    addi sp, sp, -8
; RV64I-LP64E-NEXT:    andi sp, sp, -2048
; RV64I-LP64E-NEXT:    addi a0, sp, 2047
; RV64I-LP64E-NEXT:    addi a0, a0, 1
; RV64I-LP64E-NEXT:    call callee
; RV64I-LP64E-NEXT:    addi sp, s0, -2040
; RV64I-LP64E-NEXT:    .cfi_def_cfa sp, 2040
; RV64I-LP64E-NEXT:    ld ra, 2032(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    ld s0, 2024(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    .cfi_restore ra
; RV64I-LP64E-NEXT:    .cfi_restore s0
; RV64I-LP64E-NEXT:    addi sp, sp, 2040
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 0
; RV64I-LP64E-NEXT:    ret
  %1 = alloca i8, align 2048
  call void @callee(ptr %1)
  ret void
}

define void @caller_no_realign2048() "no-realign-stack" {
; RV32I-LABEL: caller_no_realign2048:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    .cfi_def_cfa_offset 16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    .cfi_offset ra, -4
; RV32I-NEXT:    mv a0, sp
; RV32I-NEXT:    call callee
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    .cfi_restore ra
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    .cfi_def_cfa_offset 0
; RV32I-NEXT:    ret
;
; RV32I-ILP32E-LABEL: caller_no_realign2048:
; RV32I-ILP32E:       # %bb.0:
; RV32I-ILP32E-NEXT:    addi sp, sp, -8
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 8
; RV32I-ILP32E-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    .cfi_offset ra, -4
; RV32I-ILP32E-NEXT:    mv a0, sp
; RV32I-ILP32E-NEXT:    call callee
; RV32I-ILP32E-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    .cfi_restore ra
; RV32I-ILP32E-NEXT:    addi sp, sp, 8
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 0
; RV32I-ILP32E-NEXT:    ret
;
; RV64I-LABEL: caller_no_realign2048:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    .cfi_def_cfa_offset 16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    .cfi_offset ra, -8
; RV64I-NEXT:    mv a0, sp
; RV64I-NEXT:    call callee
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    .cfi_restore ra
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    .cfi_def_cfa_offset 0
; RV64I-NEXT:    ret
;
; RV64I-LP64E-LABEL: caller_no_realign2048:
; RV64I-LP64E:       # %bb.0:
; RV64I-LP64E-NEXT:    addi sp, sp, -16
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 16
; RV64I-LP64E-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    .cfi_offset ra, -8
; RV64I-LP64E-NEXT:    mv a0, sp
; RV64I-LP64E-NEXT:    call callee
; RV64I-LP64E-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    .cfi_restore ra
; RV64I-LP64E-NEXT:    addi sp, sp, 16
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 0
; RV64I-LP64E-NEXT:    ret
  %1 = alloca i8, align 2048
  call void @callee(ptr %1)
  ret void
}

define void @caller4096() {
; RV32I-LABEL: caller4096:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -2032
; RV32I-NEXT:    .cfi_def_cfa_offset 2032
; RV32I-NEXT:    sw ra, 2028(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 2024(sp) # 4-byte Folded Spill
; RV32I-NEXT:    .cfi_offset ra, -4
; RV32I-NEXT:    .cfi_offset s0, -8
; RV32I-NEXT:    addi s0, sp, 2032
; RV32I-NEXT:    .cfi_def_cfa s0, 0
; RV32I-NEXT:    lui a0, 2
; RV32I-NEXT:    addi a0, a0, -2032
; RV32I-NEXT:    sub sp, sp, a0
; RV32I-NEXT:    srli a0, sp, 12
; RV32I-NEXT:    slli sp, a0, 12
; RV32I-NEXT:    lui a0, 1
; RV32I-NEXT:    add a0, sp, a0
; RV32I-NEXT:    call callee
; RV32I-NEXT:    addi sp, s0, -2032
; RV32I-NEXT:    .cfi_def_cfa sp, 2032
; RV32I-NEXT:    lw ra, 2028(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 2024(sp) # 4-byte Folded Reload
; RV32I-NEXT:    .cfi_restore ra
; RV32I-NEXT:    .cfi_restore s0
; RV32I-NEXT:    addi sp, sp, 2032
; RV32I-NEXT:    .cfi_def_cfa_offset 0
; RV32I-NEXT:    ret
;
; RV32I-ILP32E-LABEL: caller4096:
; RV32I-ILP32E:       # %bb.0:
; RV32I-ILP32E-NEXT:    addi sp, sp, -2044
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 2044
; RV32I-ILP32E-NEXT:    sw ra, 2040(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    sw s0, 2036(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    .cfi_offset ra, -4
; RV32I-ILP32E-NEXT:    .cfi_offset s0, -8
; RV32I-ILP32E-NEXT:    addi s0, sp, 2044
; RV32I-ILP32E-NEXT:    .cfi_def_cfa s0, 0
; RV32I-ILP32E-NEXT:    lui a0, 2
; RV32I-ILP32E-NEXT:    addi a0, a0, -2044
; RV32I-ILP32E-NEXT:    sub sp, sp, a0
; RV32I-ILP32E-NEXT:    srli a0, sp, 12
; RV32I-ILP32E-NEXT:    slli sp, a0, 12
; RV32I-ILP32E-NEXT:    lui a0, 1
; RV32I-ILP32E-NEXT:    add a0, sp, a0
; RV32I-ILP32E-NEXT:    call callee
; RV32I-ILP32E-NEXT:    addi sp, s0, -2044
; RV32I-ILP32E-NEXT:    .cfi_def_cfa sp, 2044
; RV32I-ILP32E-NEXT:    lw ra, 2040(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    lw s0, 2036(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    .cfi_restore ra
; RV32I-ILP32E-NEXT:    .cfi_restore s0
; RV32I-ILP32E-NEXT:    addi sp, sp, 2044
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 0
; RV32I-ILP32E-NEXT:    ret
;
; RV64I-LABEL: caller4096:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -2032
; RV64I-NEXT:    .cfi_def_cfa_offset 2032
; RV64I-NEXT:    sd ra, 2024(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 2016(sp) # 8-byte Folded Spill
; RV64I-NEXT:    .cfi_offset ra, -8
; RV64I-NEXT:    .cfi_offset s0, -16
; RV64I-NEXT:    addi s0, sp, 2032
; RV64I-NEXT:    .cfi_def_cfa s0, 0
; RV64I-NEXT:    lui a0, 2
; RV64I-NEXT:    addiw a0, a0, -2032
; RV64I-NEXT:    sub sp, sp, a0
; RV64I-NEXT:    srli a0, sp, 12
; RV64I-NEXT:    slli sp, a0, 12
; RV64I-NEXT:    lui a0, 1
; RV64I-NEXT:    add a0, sp, a0
; RV64I-NEXT:    call callee
; RV64I-NEXT:    addi sp, s0, -2032
; RV64I-NEXT:    .cfi_def_cfa sp, 2032
; RV64I-NEXT:    ld ra, 2024(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 2016(sp) # 8-byte Folded Reload
; RV64I-NEXT:    .cfi_restore ra
; RV64I-NEXT:    .cfi_restore s0
; RV64I-NEXT:    addi sp, sp, 2032
; RV64I-NEXT:    .cfi_def_cfa_offset 0
; RV64I-NEXT:    ret
;
; RV64I-LP64E-LABEL: caller4096:
; RV64I-LP64E:       # %bb.0:
; RV64I-LP64E-NEXT:    addi sp, sp, -2040
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 2040
; RV64I-LP64E-NEXT:    sd ra, 2032(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    sd s0, 2024(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    .cfi_offset ra, -8
; RV64I-LP64E-NEXT:    .cfi_offset s0, -16
; RV64I-LP64E-NEXT:    addi s0, sp, 2040
; RV64I-LP64E-NEXT:    .cfi_def_cfa s0, 0
; RV64I-LP64E-NEXT:    lui a0, 2
; RV64I-LP64E-NEXT:    addiw a0, a0, -2040
; RV64I-LP64E-NEXT:    sub sp, sp, a0
; RV64I-LP64E-NEXT:    srli a0, sp, 12
; RV64I-LP64E-NEXT:    slli sp, a0, 12
; RV64I-LP64E-NEXT:    lui a0, 1
; RV64I-LP64E-NEXT:    add a0, sp, a0
; RV64I-LP64E-NEXT:    call callee
; RV64I-LP64E-NEXT:    addi sp, s0, -2040
; RV64I-LP64E-NEXT:    .cfi_def_cfa sp, 2040
; RV64I-LP64E-NEXT:    ld ra, 2032(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    ld s0, 2024(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    .cfi_restore ra
; RV64I-LP64E-NEXT:    .cfi_restore s0
; RV64I-LP64E-NEXT:    addi sp, sp, 2040
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 0
; RV64I-LP64E-NEXT:    ret
  %1 = alloca i8, align 4096
  call void @callee(ptr %1)
  ret void
}

define void @caller_no_realign4096() "no-realign-stack" {
; RV32I-LABEL: caller_no_realign4096:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    .cfi_def_cfa_offset 16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    .cfi_offset ra, -4
; RV32I-NEXT:    mv a0, sp
; RV32I-NEXT:    call callee
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    .cfi_restore ra
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    .cfi_def_cfa_offset 0
; RV32I-NEXT:    ret
;
; RV32I-ILP32E-LABEL: caller_no_realign4096:
; RV32I-ILP32E:       # %bb.0:
; RV32I-ILP32E-NEXT:    addi sp, sp, -8
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 8
; RV32I-ILP32E-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    .cfi_offset ra, -4
; RV32I-ILP32E-NEXT:    mv a0, sp
; RV32I-ILP32E-NEXT:    call callee
; RV32I-ILP32E-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    .cfi_restore ra
; RV32I-ILP32E-NEXT:    addi sp, sp, 8
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 0
; RV32I-ILP32E-NEXT:    ret
;
; RV64I-LABEL: caller_no_realign4096:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    .cfi_def_cfa_offset 16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    .cfi_offset ra, -8
; RV64I-NEXT:    mv a0, sp
; RV64I-NEXT:    call callee
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    .cfi_restore ra
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    .cfi_def_cfa_offset 0
; RV64I-NEXT:    ret
;
; RV64I-LP64E-LABEL: caller_no_realign4096:
; RV64I-LP64E:       # %bb.0:
; RV64I-LP64E-NEXT:    addi sp, sp, -16
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 16
; RV64I-LP64E-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    .cfi_offset ra, -8
; RV64I-LP64E-NEXT:    mv a0, sp
; RV64I-LP64E-NEXT:    call callee
; RV64I-LP64E-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    .cfi_restore ra
; RV64I-LP64E-NEXT:    addi sp, sp, 16
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 0
; RV64I-LP64E-NEXT:    ret
  %1 = alloca i8, align 4096
  call void @callee(ptr %1)
  ret void
}
