# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -march=aarch64 -mcpu=exynos-m3 -resource-pressure=false < %s | FileCheck %s -check-prefixes=ALL,M3
# RUN: llvm-mca -march=aarch64 -mcpu=exynos-m4 -resource-pressure=false < %s | FileCheck %s -check-prefixes=ALL,M4
# RUN: llvm-mca -march=aarch64 -mcpu=exynos-m5 -resource-pressure=false < %s | FileCheck %s -check-prefixes=ALL,M5

  mov	x0, x1
  mov	sp, x0

  mov	w0, #0x3210
  add	w0, w1, #0

  adr	x0, 1f
  ldr	x0, [x0]

  adrp	x0, 1f
  add	x0, x0, :lo12:1f

  fmov	s0, s1

  movi	d0, #0

1:

# ALL:      Iterations:        100
# ALL-NEXT: Instructions:      1000
# ALL-NEXT: Total Cycles:      172
# ALL-NEXT: Total uOps:        1000

# ALL:      Dispatch Width:    6
# ALL-NEXT: uOps Per Cycle:    5.81
# ALL-NEXT: IPC:               5.81
# ALL-NEXT: Block RThroughput: 1.7

# ALL:      Instruction Info:
# ALL-NEXT: [1]: #uOps
# ALL-NEXT: [2]: Latency
# ALL-NEXT: [3]: RThroughput
# ALL-NEXT: [4]: MayLoad
# ALL-NEXT: [5]: MayStore
# ALL-NEXT: [6]: HasSideEffects (U)

# ALL:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# ALL-NEXT:  1      0     0.17                        mov	x0, x1
# ALL-NEXT:  1      0     0.17                        mov	sp, x0
# ALL-NEXT:  1      0     0.17                        mov	w0, #12816

# M3-NEXT:   1      1     0.25                        add	w0, w1, #0
# M4-NEXT:   1      1     0.25                        add	w0, w1, #0
# M5-NEXT:   1      1     0.17                        add	w0, w1, #0

# ALL-NEXT:  1      0     0.17                        adr	x0, {{\.?}}Ltmp0
# ALL-NEXT:  1      4     0.50    *                   ldr	x0, [x0]
# ALL-NEXT:  1      0     0.17                        adrp	x0, {{\.?}}Ltmp0
# ALL-NEXT:  1      1     0.25                        add	x0, x0, :lo12:{{\.?}}Ltmp0

# M3-NEXT:   1      1     0.33                        fmov	s0, s1
# M4-NEXT:   1      1     0.33                        fmov	s0, s1
# M5-NEXT:   1      2     0.33                        fmov	s0, s1

# ALL-NEXT:  1      0     0.17                        movi	d0, #0000000000000000
