; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; Test i128 byteswaps on z13 and higher.
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z13 | FileCheck %s

declare i128 @llvm.bswap.i128(i128 %a)

; Check 128-bit register-to-register byteswaps.
define i128 @f1(i128 %a, i128 %b, i128 %c) {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v1, 0(%r4), 3
; CHECK-NEXT:    vl %v2, 0(%r3), 3
; CHECK-NEXT:    larl %r1, .LCPI0_0
; CHECK-NEXT:    vaq %v1, %v2, %v1
; CHECK-NEXT:    vl %v2, 0(%r1), 3
; CHECK-NEXT:    vl %v0, 0(%r5), 3
; CHECK-NEXT:    vperm %v1, %v1, %v1, %v2
; CHECK-NEXT:    vaq %v0, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %in = add i128 %a, %b
  %swapped = call i128 @llvm.bswap.i128(i128 %in)
  %out = add i128 %swapped, %c
  ret i128 %out
}

; Check 128-bit register-to-memory byteswaps.
define i128 @f2(i128 %a, i128 %b) {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r4), 3
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    larl %r1, .LCPI1_0
; CHECK-NEXT:    vaq %v0, %v1, %v0
; CHECK-NEXT:    vl %v1, 0(%r1), 3
; CHECK-NEXT:    vperm %v0, %v0, %v0, %v1
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %in = add i128 %a, %b
  %swapped = call i128 @llvm.bswap.i128(i128 %in)
  ret i128 %swapped
}

; Check 128-bit memory-to-register byteswaps.
define i128 @f3(i128 %a, i128 %b) {
; CHECK-LABEL: f3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    larl %r1, .LCPI2_0
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    vl %v2, 0(%r1), 3
; CHECK-NEXT:    vl %v0, 0(%r4), 3
; CHECK-NEXT:    vperm %v1, %v1, %v1, %v2
; CHECK-NEXT:    vaq %v0, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %swapped = call i128 @llvm.bswap.i128(i128 %a)
  %out = add i128 %swapped, %b
  ret i128 %out
}

